#ifndef DEMANGLE_H
#define DEMANGLE_H 1
#include <string>

#ifdef _WIN32
#include <typeinfo>
namespace {
std::string demangle(const char* mangled_name) noexcept {
  return mangled_name;
}
}
#else // __linux__
#include <cxxabi.h>
namespace {
std::string demangle(const char* mangled_name) noexcept {
  int error = 0;
  char *demang_name = abi::__cxa_demangle(mangled_name, 0, 0, &error);

  switch (error) {
  case 0:
    break;
  case -1:
    return "memory allocation failed";
  case -2:
    return "not a valid mangled name";
  case -3:
    return "invalid arguments";
  default:
    return "__cxa_demangle failed";
  }

  std::string name(demang_name);
  free(demang_name);

  return name.substr(name.find_last_of("::") + 1);
}
}
#endif // __linux__
#endif
