(*
Module: NutUpsConf
 Parses /etc/nut/ups.conf

Author: Raphael Pinson <raphink@gmail.com>
        Frederic Bohe  <fredericbohe@eaton.com>
        Arnaud Quette  <arnaud.quette@gmail.com>
        Jim Klimov     <jimklimov+nut@gmail.com>

About: License
  This file is licensed under the GPL.

About: Lens Usage
  Sample usage of this lens in augtool

    * Print all drivers used
      > print /files//etc/nut/ups.conf/*/driver

About: Configuration files
  This lens applies to /etc/nut/ups.conf. See <filter>.
*)

module NutUpsConf =
  autoload ups_xfm

(************************************************************************
 * Group:                 UPS.CONF
 *************************************************************************)

let ups_comment  = IniFile.comment IniFile.comment_re IniFile.comment_default

let ups_sep      = IniFile.sep IniFile.sep_re IniFile.sep_default

let ups_global   = "chroot"
                 | "driverpath"
                 | "maxstartdelay"
                 | "maxretry"
                 | "nowait"
                 | "retrydelay"
                 | "pollinterval"
                 | "synchronous"
                 | "user"
                 | "group"
                 | "debug_min"
                 | "STATEPATH"
                 | "statepath"

(* This expression did involve a lot of courtship around the parser *)
let ups_fields_re = /(default|override)\.[^:=#\r\t\n \/]+/

let ups_fields   = "driver"
                 | "port"
                 | "sdorder"
                 | "desc"
                 | "nolock"
                 | "ignorelb"
                 | "maxstartdelay"
                 | "synchronous"
                 | "user"
                 | "group"
                 | "debug_min"
                 | "LIBUSB_DEBUG"
                 | "BYPASS"
                 | "CHRG_addr"
                 | "CHRG_noro"
                 | "CHRG_regtype"
                 | "CP"
                 | "CS"
                 | "DISCHRG_addr"
                 | "DISCHRG_noro"
                 | "DISCHRG_regtype"
                 | "FSD_addr"
                 | "FSD_noro"
                 | "FSD_pulse_duration"
                 | "FSD_regtype"
                 | "HB_addr"
                 | "HB_noro"
                 | "HB_regtype"
                 | "ID"
                 | "LB"
                 | "LB_addr"
                 | "LB_noro"
                 | "LB_regtype"
                 | "LowBatt"
                 | "OB_addr"
                 | "OB_noro"
                 | "OB_regtype"
                 | "OL"
                 | "OL_addr"
                 | "OL_noro"
                 | "OL_regtype"
                 | "OffDelay"
                 | "OnDelay"
                 | "RB"
                 | "RB_addr"
                 | "RB_noro"
                 | "RB_regtype"
                 | "SD"
                 | "addr"
                 | "advanced_eco_mode"
                 | "advorder"
                 | "ah"
                 | "alarm_control"
                 | "allow_duplicates"
                 | "authPassword"
                 | "authProtocol"
                 | "authtype"
                 | "awd"
                 | "batteryPercentage"
                 | "battery_alarm"
                 | "battery_max"
                 | "battery_min"
                 | "battery_number"
                 | "battery_open_status_check"
                 | "battery_voltage_reports_one_pack"
                 | "battext"
                 | "battvoltmult"
                 | "baud"
                 | "baud_rate"
                 | "baudrate"
                 | "bus"
                 | "busport"
                 | "bypass_alarm"
                 | "bypass_forbidding"
                 | "bypass_when_off"
                 | "cable"
                 | "cablepower"
                 | "chargetime"
                 | "checkruntime"
                 | "community"
                 | "constant_phase_angle"
                 | "converter_mode"
                 | "coolofftime"
                 | "cshdelay"
                 | "databits"
                 | "daysoff"
                 | "daysweek"
                 | "deadtime"
                 | "debug_pkt_data"
                 | "debug_pkt_hwinfo"
                 | "debug_pkt_raw"
                 | "dev_slave_id"
                 | "device"
                 | "device_mfr"
                 | "device_model"
                 | "disable_fix_report_desc"
                 | "disptesttime"
                 | "do_convert_deci"
                 | "dumbterm"
                 | "eco_mode"
                 | "explore"
                 | "fake_lowbatt"
                 | "fault_1"
                 | "fault_2"
                 | "fault_3"
                 | "fault_4"
                 | "fault_5"
                 | "flash"
                 | "frequency"
                 | "fruid"
                 | "fsdmode"
                 | "full_update"
                 | "hb"
                 | "houroff"
                 | "houron"
                 | "i2c_address"
                 | "idleload"
                 | "ignoresab"
                 | "inittime"
                 | "input_fault_voltage"
                 | "input_timeout"
                 | "interrupt_pipe_no_events_tolerance"
                 | "interruptonly"
                 | "interruptsize"
                 | "langid_fix"
                 | "lb"
                 | "lbrb_log_delay_sec"
                 | "lbrb_log_delay_without_calibrating"
                 | "limited_runtime_on_battery"
                 | "linevoltage"
                 | "load.off"
                 | "load.on"
                 | "load.status"
                 | "loadPercentage"
                 | "localcalculation"
                 | "login"
                 | "lowbatt"
                 | "manufacturer"
                 | "max_bypass_freq"
                 | "max_bypass_volt"
                 | "max_load"
                 | "max_polls_without_data"
                 | "maxconnfails"
                 | "maxreport"
                 | "methodOfFlowControl"
                 | "mfr"
                 | "mibs"
                 | "min_bypass_freq"
                 | "min_bypass_volt"
                 | "mincharge"
                 | "minruntime"
                 | "mod_byte_to_s"
                 | "mod_byte_to_us"
                 | "mod_resp_to_s"
                 | "mod_resp_to_us"
                 | "model"
                 | "modelname"
                 | "nobt"
                 | "nohang"
                 | "nombattvolt"
                 | "nominal_cell_voltage"
                 | "nooutstats"
                 | "noprimarytime"
                 | "norating"
                 | "noscanlangid"
                 | "notification"
                 | "notransferoids"
                 | "novendor"
                 | "nowarn_noimp"
                 | "numOfBytesFromUPS"
                 | "numbatteries"
                 | "number_of_battery_cells"
                 | "offdelay"
                 | "oldmac"
                 | "ondelay"
                 | "onlinedischarge"
                 | "onlinedischarge_calibration"
                 | "onlinedischarge_log_throttle_hovercharge"
                 | "onlinedischarge_log_throttle_sec"
                 | "onlinedischarge_onbattery"
                 | "output_pace"
                 | "output_phase_angle"
                 | "output_voltages"
                 | "parity"
                 | "password"
                 | "pf"
                 | "pins_shutdown_mode"
                 | "pollfreq"
                 | "pollonly"
                 | "porttype"
                 | "powercom_sdcmd_byte_order_fallback"
                 | "powerup"
                 | "prefix"
                 | "prgshut"
                 | "privPassword"
                 | "privProtocol"
                 | "product"
                 | "productid"
                 | "protocol"
                 | "pvbaud"
                 | "rebootdelay"
                 | "recharge_time"
                 | "relogtime"
                 | "repeater_disable_strict_start"
                 | "reset_to_default"
                 | "response_timeout_ms"
                 | "retry"
                 | "rio_slave_id"
                 | "rules"
                 | "runtime_full"
                 | "runtime_half"
                 | "runtimecal"
                 | "sdtime"
                 | "sdtype"
                 | "secLevel"
                 | "secName"
                 | "semistaticfreq"
                 | "sensorid"
                 | "ser_baud_rate"
                 | "ser_data_bit"
                 | "ser_parity"
                 | "ser_stop_bit"
                 | "serial"
                 | "serialnumber"
                 | "series"
                 | "shutdownArguments"
                 | "shutdown_delay"
                 | "shutdown_duration"
                 | "shutdown_timer"
                 | "silent"
                 | "site_fault_detection"
                 | "slave_address"
                 | "slaveid"
                 | "snmp_retries"
                 | "snmp_timeout"
                 | "snmp_version"
                 | "startdelay"
                 | "status_have_all"
                 | "status_have_any"
                 | "status_nothave_all"
                 | "status_nothave_any"
                 | "status_only"
                 | "stayoff"
                 | "stopbits"
                 | "strictfiltering"
                 | "subdriver"
                 | "subscribe"
                 | "symmetrathreephase"
                 | "sysfs_dir"
                 | "testing"
                 | "testtime"
                 | "timeout"
                 | "ttymode"
                 | "type"
                 | "ups.delay.shutdown"
                 | "ups.delay.start"
                 | "upsid"
                 | "upstype"
                 | "usb_config_index"
                 | "usb_hid_desc_index"
                 | "usb_hid_ep_in"
                 | "usb_hid_ep_out"
                 | "usb_hid_rep_index"
                 | "usb_set_altinterface"
                 | "usd"
                 | "use_crlf"
                 | "use_pre_lf"
                 | "username"
                 | "va"
                 | "validationSequence"
                 | "vbat"
                 | "vendor"
                 | "vendorid"
                 | "vin_high_crit_perc"
                 | "vin_high_warn_perc"
                 | "vin_low_crit_perc"
                 | "vin_low_warn_perc"
                 | "voltage"
                 | "wait"
                 | "waitbeforereconnect"
                 | "work_range_type"
                 | "wugrace"


let ups_entry    = IniFile.indented_entry (ups_global|ups_fields|ups_fields_re) ups_sep ups_comment

let ups_title    = IniFile.indented_title IniFile.record_re

let ups_record   = IniFile.record ups_title ups_entry

let ups_lns      = IniFile.lns ups_record ups_comment

let ups_filter   = (incl "/etc/nut/ups.conf")
                . Util.stdexcl

let ups_xfm      = transform ups_lns ups_filter
